<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('referral_payouts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('referral_user_id');
            $table->decimal('amount', 10, 2);
            $table->enum('status', ['requested', 'processing', 'paid', 'rejected'])->default('requested');
            $table->string('attachment_url')->nullable(); // Payment proof
            $table->text('notes')->nullable();
            $table->string('payment_method')->nullable(); // bank, paypal, etc.
            $table->json('payment_details')->nullable(); // Bank account details, etc.
            $table->timestamp('requested_at')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->unsignedBigInteger('processed_by')->nullable(); // Admin user who processed
            $table->timestamps();

            $table->foreign('referral_user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('processed_by')->references('id')->on('users')->onDelete('set null');
            $table->index(['referral_user_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('referral_payouts');
    }
};
