<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assets', function (Blueprint $table) {
            $table->id();
            $table->string('asset_name')->nullable();
            $table->integer('category')->nullable();
            $table->integer('site_id')->nullable();
            $table->string('model')->nullable();
            $table->string('serial_number')->nullable();
            $table->date('purchase_date');
            $table->decimal('purchase_price', 10, 2);
            $table->string('vendor')->nullable();
            $table->date('warranty_expiry')->nullable();
            $table->string('location')->nullable();
            $table->string('assigned_to')->nullable();
            $table->integer('status');
            $table->text('description')->nullable();
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('workspace_id');
            $table->timestamps();

            // Add indexes for better performance
            $table->index(['customer_id', 'workspace_id']);
            $table->index('category');
            $table->index('status');
            $table->index('serial_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assets');
    }
};
