<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSalariesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('salaries', function (Blueprint $table) {
            $table->id();
            $table->integer('employee_id');
            $table->date('from');
            $table->date('to');
            $table->decimal('basic_salary', 10, 2);
            $table->float('working_hours'); // Store as string for flexibility
            $table->integer('customer_id');
            $table->integer('workspace_id');
            $table->integer('created_by')->nullable();
            $table->timestamps();

            // Indexes
            $table->index(['employee_id', 'from', 'to']);
            $table->index(['customer_id', 'workspace_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('salaries');
    }
}
