<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_diaries', function (Blueprint $table) {
            $table->id();
            $table->integer('site_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->date('diary_date')->nullable();
            $table->string('weather')->nullable(); // sunny, cloudy, rainy, etc.
            $table->text('work_log')->nullable();
            $table->text('notes')->nullable();
            $table->integer('created_by')->nullable();
            $table->string('created_by_type')->nullable();
            $table->text('summary')->nullable();
            $table->string('del')->default('0');
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['customer_id', 'workspace_id']);
            $table->index(['site_id', 'diary_date']);
            $table->unique(['site_id', 'diary_date', 'customer_id', 'workspace_id'], 'unique_site_diary_per_day');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_diaries');
    }
};