<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInductionDocumentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('induction_documents', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('document_type')->nullable();
            $table->json('role_types')->nullable();
            $table->string('version', 10)->default('v1')->nullable();
            $table->string('file_path')->nullable();
            $table->boolean('is_active')->default(true)->nullable();
            $table->enum('update_type', ['major', 'minor'])->nullable();
            $table->integer('parent_document_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('created_by')->nullable();
            $table->text('description')->nullable();
            $table->enum('del', [0, 1])->default(0)->nullable();
            $table->timestamps();
            
            // Indexes for better query performance
            $table->index(['customer_id', 'workspace_id']);
            $table->index('is_active');
            $table->index('parent_document_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('induction_documents');
    }
}
