<?php

namespace Database\Seeders;

use App\Models\DocumentType;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DocumentTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $documentTypes = [
            'Building Permit / Construction Approval',
            'Development Consent',
            'Council Approvals',
            'Utility Disconnection or Relocation Approvals',
            'Environmental Impact Assessment (if applicable)',
            'Dial-Before-You-Dig (DBYD) Report',
            'Traffic Management Approval (for road-adjacent works)',
            'Site Safety Management Plan (SMP)',
            'WHS Management Plan',
            'Safe Work Method Statements (SWMS) for all high-risk work',
            'Site-Specific Risk Assessments',
            'Initial Hazard/Risk Register',
            'Emergency Response Plan & Site Map',
            'Site Induction Procedure',
            'PPE Requirements Document',
            'Safety Data Sheets (SDS) for all chemicals to be used',
            'Company Registration',
            'Public Liability Insurance Certificate',
            'Workers\' Compensation Insurance Certificate',
            'High-Risk Work Licences (EWP, Crane, Rigging, etc.)',
            'Construction Induction Cards (White Cards)',
            'Operator or Plant Tickets',
            'Safety Management System Evidence',
            'Trade Competency Certificates',
            'Signed Subcontract Agreements / Contracts',
            'Approved Architectural Drawings (latest revision)',
            'Structural Drawings',
            'Mechanical, Electrical & Plumbing (MEP) Plans',
            'Civil/Infrastructure Drawings -Specifications Documentation',
            'Final Scope of Works',
            'Geotechnical / Soil Testing Report',
            'Engineering Certifications',
            'Survey Plans',
            'Design Coordination Layouts',
            'Construction Programme / Master Timeline',
            'Staging and Sequencing Plan',
            'Site Logistics Plan (access, storage, laydown areas)',
            'Temporary Facilities Plan (site office, welfare units, power)',
            'Crane and Lifting Plans (where applicable)',
            'Traffic Management Plan (TMP)',
            'Material Handling Plan',
            'Site Setup Checklist',
            'Environmental Management Plan (EMP)',
            'Waste Management and Recycling Plan',
            'Erosion & Sediment Control Plan',
            'Noise and Vibration Management Plan',
            'Hazardous Materials Management Plan (if relevant)',
            'Contract Agreement',
            'Bill of Quantities (BOQ)',
            'Tender Documentation',
            'Procurement Schedule',
            'Work Breakdown Structure (WBS)'
        ];

        foreach ($documentTypes as $index => $title) {
            DocumentType::updateOrCreate(
                ['title' => $title],
                [
                    'title' => $title,
                    'del' => '0'
                ]
            );
        }

        echo "Document types seeded successfully. Total: " . count($documentTypes) . "\n";
    }
}

