@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id ?? null);
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress =
        $companyDetails['companyAddressFull'] ??
        trim(
            ($companyAddress ?? '') .
                ', ' .
                ($companyCity ?? '') .
                ', ' .
                ($companyState ?? '') .
                ', ' .
                ($companyPostCode ?? '') .
                ', ' .
                ($companyCountry ?? ''),
        );
@endphp
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif !important;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }

        #email-header {
            padding: 18px 25px;
            background: #fff !important;
        }

        #email-content {
            padding: 42px 34px;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 18px;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.5;
        }

        .title {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 18px;
            color: #1f2937;
        }

        .details-container {
            background-color: #f0fdf4;
            padding: 30px 20px;
            border-radius: 8px;
            margin: 25px 0;
            border: 2px solid #22C55E;
        }

        .details-label {
            font-size: 12px;
            color: #16a34a;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }

        .details-item {
            margin-bottom: 12px;
        }

        .details-item-label {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .details-item-value {
            font-size: 15px;
            color: #15803d;
            background-color: #dcfce7;
            padding: 10px;
            border-radius: 4px;
        }

        .action-button {
            display: inline-block;
            margin-top: 15px;
            padding: 12px 24px;
            background-color: #22C55E;
            color: white !important;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 14px;
            text-align: center;
        }

        .security-warning {
            background-color: #fef3c7;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #f59e0b;
            font-size: 14px;
            color: #92400e;
        }

        .security-warning strong {
            font-weight: 600;
            color: #d97706;
        }

        #email-footer {
            margin-top: 20px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 16px;
            text-align: center;
            font-size: 13px;
            color: #6b7280;
        }

        .small-tagline {
            font-size: 13px;
            color: #6b7280;
            margin-bottom: 4px;
        }

        .big-tagline {
            font-size: 14px;
            color: #374151;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .big-tagline a:hover {
            text-decoration: underline;
        }

        .company-details {
            text-align: center;
            padding: 20px 0;
            background-color: #ffffff;
        }

        .footer-logo {
            height: 35px;
            margin-bottom: 10px;
           
        }

        .company-title {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 12px;
            line-height: 1.4;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
                <h2 style="color: black; margin: 0; font-weight: 600;">{{ $companyName }}</h2>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">Hi {{ $creator_name ?? 'there' }},</div>
            <div class="email-content-area">
                <p class="title">🔔 Defect Status Update</p>
                <p>There is an update on your defect/task. See the details below:</p>

                <div class="details-container">
                    <div class="details-label">Defect Details</div>

                    <div class="details-item">
                        <div class="details-item-label">Title</div>
                        <div class="details-item-value">{{ $defect_title }}</div>
                    </div>        
                    <div class="details-item">
                        <div class="details-item-label">Description</div>
                        <div class="details-item-value">{{ $defect_description }}</div>
                    </div> 

                    <div class="details-item">
                        <div class="details-item-label">Current Status</div>
                        <div class="details-item-value">{{ $defect_status_label }}</div>
                    </div>

                    <div class="details-item">
                        <div class="details-item-label">Priority</div>
                        <div class="details-item-value">{{ ucfirst($defect_priority) }}</div>
                    </div>

                    @if (!empty($defect_due_date))
                        <div class="details-item">
                            <div class="details-item-label">Due Date</div>
                            <div class="details-item-value">{{ $defect_due_date }}</div>
                        </div>
                    @endif

                    @if (!empty($reject_reason))
                        <div class="details-item">
                            <div class="details-item-label">Reject Reason</div>
                            <div class="details-item-value">{{ $reject_reason }}</div>
                        </div>
                    @endif

                    @if (!empty($completion_description))
                        <div class="details-item">
                            <div class="details-item-label">Completion Description</div>
                            <div class="details-item-value">{{ $completion_description }}</div>
                        </div>
                    @endif
                </div>
                @if (!empty($action_url))
                    <p><a class="action-button" href="{{ $action_url }}" target="_blank">Open in portal</a></p>
                @endif
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>

            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    {{ $fullAddress }}<br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
