@php
    use App\Services\CompanyEmailDetails;
    use Illuminate\Support\Facades\Log;

    Log::info('induction-document-notification.blade.php: Starting email template render', [
        'customer_id' => $customer_id ?? 'NULL',
        'workspace_id' => $workspace_id ?? 'NULL'
    ]);

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id ?? null, $workspace_id ?? null);
    
    Log::info('induction-document-notification.blade.php: CompanyEmailDetails returned', [
        'logoPath' => $companyDetails['logoPath'] ?? 'NULL',
        'companyName' => $companyDetails['companyName'] ?? 'NULL',
        'all_keys' => array_keys($companyDetails)
    ]);
    
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    
    // Check if logo file exists
    $logoExists = false;
    if (!empty($logoPath)) {
        $fullLogoPath = public_path($logoPath);
        $logoExists = file_exists($fullLogoPath);
        Log::info('induction-document-notification.blade.php: Logo file check', [
            'logoPath' => $logoPath,
            'fullPath' => $fullLogoPath,
            'exists' => $logoExists,
            'is_readable' => $logoExists ? is_readable($fullLogoPath) : false
        ]);
    } else {
        Log::warning('induction-document-notification.blade.php: Logo path is empty');
    }
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress =
        $companyDetails['companyAddressFull'] ??
        trim(
            ($companyAddress ?? '') .
                ', ' .
                ($companyCity ?? '') .
                ', ' .
                ($companyState ?? '') .
                ', ' .
                ($companyPostCode ?? '') .
                ', ' .
                ($companyCountry ?? ''),
        );
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif !important;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }

        #email-header {
            padding: 12px 18px;
            background: #fff !important;
        }

        #email-content {
            padding: 24px 22px;
        }

        .greeting-section {
            font-size: 13px;
            margin-bottom: 10px;
        }

        .email-content-area p {
            font-size: 13px;
            margin-bottom: 10px;
            line-height: 1.45;
        }

        .title {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 12px;
            color: #1f2937;
        }

        .details-container {
            background-color: #f9fafb;
            padding: 16px 14px;
            border-radius: 6px;
            margin: 16px 0;
            border: 1px solid #e5e7eb;
        }

        .details-label {
            font-size: 14px;
            color: #6b7280;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 10px;
        }

        .details-item {
            margin-bottom: 12px;
        }

        .details-item:last-child {
            margin-bottom: 0;
        }

        .details-item-label {
            font-size: 14px;
            font-weight: 600;
            color: #6b7280;
            margin-bottom: 4px;
        }

        .details-item-value {
            font-size: 14px;
            color: #1f2937;
            font-weight: 700;
            padding: 0;
        }

        .warning-container {
            background-color: #fef3c7;
            padding: 16px 14px;
            border-radius: 6px;
            margin: 16px 0;
            border: 1px solid #f59e0b;
        }

        .warning-label {
            font-size: 11px;
            color: #d97706;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 6px;
        }

        .warning-text {
            font-size: 13px;
            color: #92400e;
            line-height: 1.5;
        }

        .action-button {
            display: inline-block;
            margin-top: 10px;
            padding: 10px 18px;
            background-color: #22C55E;
            color: white !important;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 13px;
            text-align: center;
        }


        #email-footer {
            margin-top: 14px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 12px;
            text-align: center;
            font-size: 12px;
            color: #6b7280;
        }

        .small-tagline {
            font-size: 12px;
            color: #6b7280;
            margin-bottom: 2px;
        }

        .big-tagline {
            font-size: 13px;
            color: #374151;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .big-tagline a:hover {
            text-decoration: underline;
        }

        .company-details {
            text-align: center;
            padding: 14px 0;
            background-color: #ffffff;
        }

        .footer-logo {
            height: 30px;
            margin-bottom: 8px;
        }

        .company-title {
            font-size: 13px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 11px;
            line-height: 1.35;
        }

        /* App badge */
        .app-download {
            margin-top: 10px;
        }

        .store-card {
            display: inline-block;
            background: #0f172a;
            padding: 0px 10px;
            border-radius: 8px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        }

        .store-badge {
            display: inline-block;
            line-height: 0;
        }

        .store-caption {
            font-size: 10px;
            color: #6b7280;
            margin-top: 6px;
            text-align: center;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @php
                $logoDisplayPath = null;
                if (!empty($logoPath)) {
                    $fullPath = public_path($logoPath);
                    if (file_exists($fullPath)) {
                        $logoDisplayPath = url($logoPath);
                        Log::info('induction-document-notification.blade.php: Logo will be displayed', [
                            'logoPath' => $logoPath,
                            'displayUrl' => $logoDisplayPath
                        ]);
                    } else {
                        Log::warning('induction-document-notification.blade.php: Logo file does not exist', [
                            'logoPath' => $logoPath,
                            'fullPath' => $fullPath
                        ]);
                    }
                } else {
                    Log::warning('induction-document-notification.blade.php: Logo path is empty, showing company name instead');
                }
            @endphp
            @if (!empty($logoDisplayPath))
                <img src="{{ $logoDisplayPath }}" height="54px" width="auto" alt="Logo">
            @else
                <h2 style="color: black; margin: 0; font-weight: 600;">{{ $companyName }}</h2>
            @endif
        </div>
        <div id="email-content">
            <div class="greeting-section">Hi {{ $employee_name ?? 'there' }},</div>
            <div class="email-content-area">
                @if ($is_update)
                    <p>An induction document has been updated. Please review the details below:</p>
                @else
                    <p>A new induction document has been created and requires your attention. Please review the details
                        below:</p>
                @endif
                <div class="details-container">
                    <div class="details-label">Document Details</div>
                    <div class="details-item">
                        <div class="details-item-value">Title</div>
                        <div class="details-item-label">{{ $document_title }}</div>
                    </div>
                    <div class="details-item">
                        <div class="details-item-value">Version</div>
                        <div class="details-item-label">{{ $document_version }}</div>
                    </div>
                </div>
                <div class="warning-container">
                    <div class="warning-label">Important Notice</div>
                    <div class="warning-text">
                        Please sign the new version of this document as soon as possible.
                    </div>
                </div>
                @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
                    <div class="app-download">
                        <div style="text-align: center;">
                            @if (env('APP_LINK_APPSTORE'))
                                <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                                    rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                                    <span class="store-badge">
                                        <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                            alt="Get it on Google Play"
                                            style="height: 42px; width: auto; border: 0; display: block;">
                                    </span>
                                </a>
                            @endif
                            @if (env('APP_LINK_APPSTORE_Apple'))
                                <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                                    rel="noopener"
                                    style="background: #000000; padding: 10px 12px; border-radius: 8px; display: inline-block; vertical-align: middle; text-decoration: none;">
                                    <table role="presentation" cellpadding="0" cellspacing="0" border="0"
                                        style="margin: 0; padding: 0;">
                                        <tr>
                                            <td style="padding: 0 6px 0 0; vertical-align: middle;">
                                                <img src="https://img.icons8.com/?size=100&id=30840&format=png&color=FFFFFF"
                                                    alt="Apple"
                                                    style="width: 20px; height: 20px; display: block; border: 0;">
                                            </td>
                                            <td style="padding: 0; vertical-align: middle;">
                                                <div
                                                    style="color: #FFFFFF; font-size: 8px; letter-spacing: 0.5px; line-height: 10px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 400;">
                                                    Download on the</div>
                                                <div
                                                    style="color: #FFFFFF; font-size: 14px; line-height: 16px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 600; margin-top: 2px;">
                                                    App Store</div>
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            @endif
                        </div>
                        <div class="store-caption">Tap to download our mobile app</div>
                    </div>
                @endif
            </div>
        </div>
        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>
            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    {{ $fullAddress }}<br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
