@php
    use App\Services\CompanyEmailDetails;

    // Get company details using global helper function
    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails();
    
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif !important;
            box-sizing: border-box;
        }

        body {
            background-color: #f8f9fa;
            padding: 20px 0;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            font-family: 'Inter', sans-serif !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        #email-header {
            padding: 18px 25px;
            background: linear-gradient(135deg, #fff 0%, #fff 100%);
            text-align: left;
        }

        #email-header img {
            height: 54px;
            width: auto;
            display: inline-block;
        }

        #email-header h2 {
            color: black;
            margin: 0;
            font-weight: 700;
            font-size: 24px;
        }

        #email-content {
            padding: 42px 34px;
            color: #333333;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 18px;
            color: #6b7280;
        }

        .payslip-title {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 18px;
            color: #1f2937;
        }

        .payslip-period {
            background-color: #f0f9ff;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #22c55e;
        }

        .payslip-period h3 {
            color: #22c55e;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .payslip-period p {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .payslip-period strong {
            color: #22c55e;
        }

        .payslip-summary {
            background-color: #f9fafb;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #e5e7eb;
        }

        .payslip-summary h3 {
            color: #374151;
            margin-bottom: 15px;
            font-size: 16px;
            font-weight: 600;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
            border-bottom: 1px solid #f3f4f6;
        }

        .summary-row:last-child {
            border-bottom: none;
            font-weight: 600;
            color: #22C55E;
            font-size: 16px;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px solid #d1fae5;
        }

        .summary-label {
            font-weight: 500;
            color: #4b5563;
        }

        .summary-value {
            font-weight: 600;
            color: #1f2937;
        }

        .attachment-notice {
            background-color: #fffbeb;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #fbbf24;
        }

        .attachment-notice p {
            color: #92400e;
            margin-bottom: 5px;
        }

        .attachment-notice strong {
            color: #78350f;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.6;
        }

        .thank-you {
            font-weight: 600;
            color: #374151;
            margin-top: 25px;
            margin-bottom: 0;
        }

        #email-footer {
            margin-top: 20px;
        }

        #tagline-section {
        background-color: #EDEDED;
        padding: 16px;
        text-align: center;
        font-size: 13px;
        color: #6b7280;
        }

        .small-tagline {
            font-size: 13px;
            color: #6b7280;
            margin-bottom: 5px;
        }

        .big-tagline {
            font-size: 14px;
            color: #374151;
            font-weight: 700;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .company-details {
            text-align: center;
            padding: 20px;
            background-color: #ffffff;
        }

        .company-title {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 12px;
            line-height: 1.4;
        }
        .footer-logo{
            height: 54px;
            width: auto;
        }
    </style>
</head>
<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
                <h3>{{ $companyName }}</h3>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">
                Hello, <h2>{{ $employee->first_name ?? '' }} {{ $employee->last_name ?? '' }}</h2>
            </div>

            <div class="payslip-title">
                📄 Your Payslip for {{ date('F Y', mktime(0, 0, 0, $payroll->pay_month, 1, $payroll->pay_year)) }}
            </div>

            <div class="payslip-period">
                <h3>💼 Payroll Period</h3>
                <p><strong>Month:</strong> {{ date('F', mktime(0, 0, 0, $payroll->pay_month, 1)) }}</p>
                <p><strong>Year:</strong> {{ $payroll->pay_year }}</p>
            </div>

            <div class="payslip-summary">
                <h3>💰 Salary Summary</h3>
                <div class="summary-row">
                    <span class="summary-label">Basic Salary:</span>
                    <span class="summary-value">${{ number_format($payroll->basic_salary, 2) }}</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">Working Hours:</span>
                    <span class="summary-value">{{ round($payroll->working_hours / 60, 2) }} hours</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">Hours Worked:</span>
                    <span class="summary-value">{{ round($payroll->hours_spent / 60, 2) }} hours</span>
                </div>
                @if (isset($payroll->overtime_hours) && $payroll->overtime_hours > 0)
                    <div class="summary-row">
                        <span class="summary-label">Overtime Hours:</span>
                        <span class="summary-value">{{ round($payroll->overtime_hours / 60, 2) }} hours</span>
                    </div>
                @endif
                <div class="summary-row">
                    <span class="summary-label">Net Salary:</span>
                    <span class="summary-value">${{ number_format($payroll->calculated_salary, 2) }}</span>
                </div>
            </div>

            @if(isset($payroll->pdf_path) && $payroll->pdf_path)
            <div class="attachment-notice">
                <p><strong>📎 Attachment:</strong> Your detailed payslip PDF is attached to this email.</p>
                <p>
                    <a href="{{ env('APP_URL') . '/' . ltrim($payroll->pdf_path, '/') }}" 
                       target="_blank" 
                       style="color: #007bff; text-decoration: none; font-weight: bold;">
                        🔗 View Payslip PDF Online
                    </a>
                </p>
                <p>Please save this document for your records.</p>
            </div>
            @endif

            <div class="email-content-area">
                <p>Please find your payslip attached to this email. This document contains detailed information about
                    your salary, deductions, and other relevant payroll information.</p>

                <p>If you have any questions about your payslip or need clarification on any deductions, please contact
                    your HR department or payroll administrator.</p>

                <p><strong>Important:</strong> Please keep this payslip for your records as it serves as proof of income
                    and employment.</p>

                <p class="thank-you">Thank you,<br>{{ $companyName }} Team</p>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact 
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>
            
            <div class="company-details">
                @if(!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    @if ($companyAddress)
                        {{ $companyAddress }}
                    @endif
                    @if ($companyCity || $companyState || $companyPostCode)
                        @if ($companyAddress), @endif{{ $companyCity }}{{ $companyState ? ', ' . $companyState : '' }}{{ $companyPostCode ? ' ' . $companyPostCode : '' }}
                    @endif
                    @if ($companyCountry)
                        @if ($companyAddress || $companyCity || $companyState || $companyPostCode), @endif{{ $companyCountry }}
                    @endif
                    <br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>
</html>
