@php
    use App\Services\CompanyEmailDetails;

    // Get company details using global helper function
    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails();

    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif !important;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }

        #email-header {
            padding: 18px 25px;
            background: linear-gradient(135deg, #fff 0%, #fff 100%);
        }

        #email-content {
            padding: 42px 34px;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 18px;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.5;
        }

        .schedule-title {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 18px;
            color: #1f2937;
        }

        .schedule-container {
            background-color: #f0fdf4;
            padding: 30px 20px;
            border-radius: 8px;
            margin: 25px 0;
            text-align: center;
            border: 2px solid #22C55E;
        }
        .schedule-label {
            font-size: 12px;
            color: #16a34a;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }
        .action-button {
            display: inline-block;
            background-color: #22C55E;
            color: white;
            font-weight: 600;
            padding: 12px 25px;
            border-radius: 6px;
            text-decoration: none;
            margin: 15px 0;
            font-size: 14px;
        }
        .note-container {
            background-color: #f0f9ff;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #0284c7;
            font-size: 14px;
            color: #0369a1;
        }
        .note-container strong {
            font-weight: 600;
            color: #0284c7;
        }
        .info-box {
            background-color: #f9fafb;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            font-size: 14px;
            color: #4b5563;
            border: 1px solid #e5e7eb;
        }
        .thank-you-section {
            margin-top: 25px;
            margin-bottom: 0;
            font-weight: 500;
        }
        #email-footer {
            margin-top: 20px;
        }
        #tagline-section {
            background-color: #EDEDED;
            padding: 16px;
            text-align: center;
            font-size: 13px;
            color: #6b7280;
        }
        .small-tagline {
            font-size: 13px;
            color: #6b7280;
            margin-bottom: 4px;
        }
        .big-tagline {
            font-size: 14px;
            color: #374151;
            font-weight: 700;
        }
        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }
        .big-tagline a:hover {
            text-decoration: underline;
        }
        .company-details {
            text-align: center;
            padding: 20px 0;
            background-color: #ffffff;
        }
        .footer-logo {
            height: 35px;
            margin-bottom: 10px;

        }
        .company-title {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }
        .company-address-contact {
            color: #6b7280;
            font-size: 12px;
            line-height: 1.4;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
                <h3 style="color: black; margin: 0; font-weight: 600;">{{ $companyName }}</h3>
            @endif
        </div>
        <div id="email-content">
            <div class="greeting-section">Hello, <h2>{{ $name }}</h2>
            </div>
            <div class="email-content-area">
                @if (isset($is_edit) && $is_edit)
                    <p class="schedule-title">Work Schedule Updated</p>
                    <p>Your work schedule has been updated. Please review the changes below:</p>
                @else
                    <p class="schedule-title">Work Schedule Notification</p>
                    <p>This is to inform you about your work schedule assignment. Please review the details below:</p>
                @endif
                @if (isset($is_edit) && $is_edit && isset($changes) && !empty($changes))
                    <div class="note-container" style="background-color: #fef3c7; border-left-color: #f59e0b;">
                        <strong>Changes Made:</strong><br>
                        @foreach ($changes as $field => $change)
                            @php
                                $fieldName = ucfirst(str_replace('_', ' ', $field));
                                if ($field === 'start_time') {
                                    $fieldName = 'Start Time';
                                } elseif ($field === 'end_time') {
                                    $fieldName = 'End Time';
                                } elseif ($field === 'break_minutes') {
                                    $fieldName = 'Break Time';
                                } elseif ($field === 'color_code') {
                                    $fieldName = 'Color Code';
                                } elseif ($field === 'working_hours') {
                                    $fieldName = 'Working Hours';
                                }
                            @endphp
                            <strong>{{ $fieldName }}:</strong>
                            @if ($field === 'start_time' || $field === 'end_time')
                                {{ date('h:i A', strtotime($change['old'])) }} →
                                {{ date('h:i A', strtotime($change['new'])) }}
                            @elseif($field === 'working_hours')
                                {{ round($change['old'] / 60, 2) }} hours → {{ round($change['new'] / 60, 2) }} hours
                            @else
                                {{ $change['old'] }} → {{ $change['new'] }}
                            @endif
                            <br>
                        @endforeach
                    </div>
                @endif
                <div class="schedule-container">
                    <div class="schedule-label">
                        @if (isset($roster_template_name) && !empty($roster_template_name))
                            {{ $roster_template_name }}
                        @else
                            Your Work Schedule
                        @endif
                    </div>
                    @if (isset($schedule_date) && !empty($schedule_date))
                        <div style="margin: 15px 0;">
                            <div style="font-size: 18px; font-weight: 600; color: #15803d; margin-bottom: 8px;">
                                {{ $schedule_date }}
                                @if (isset($day_name) && !empty($day_name))
                                    ({{ $day_name }})
                                @endif
                            </div>
                        </div>
                    @endif
                    @if ((isset($start_time) && !empty($start_time)) || (isset($end_time) && !empty($end_time)))
                        <div style="margin: 15px 0;">
                            <div style="font-size: 16px; color: #15803d; margin-bottom: 5px;">
                                <strong>Time:</strong>
                                @if (isset($start_time) && !empty($start_time))
                                    {{ $start_time }}
                                @endif
                                @if (isset($start_time) && !empty($start_time) && (isset($end_time) && !empty($end_time)))
                                    -
                                @endif
                                @if (isset($end_time) && !empty($end_time))
                                    {{ $end_time }}
                                @endif
                            </div>
                        </div>
                    @endif
                    @if (isset($break_minutes) && !empty($break_minutes) && $break_minutes > 0)
                        <div style="margin: 10px 0;">
                            <div style="font-size: 14px; color: #15803d;">
                                ☕ <strong>Break Time:</strong> {{ $break_minutes }} minutes
                            </div>
                        </div>
                    @endif
                    @if (isset($working_hours) && !empty($working_hours) && $working_hours > 0)
                        <div style="margin: 10px 0;">
                            <div style="font-size: 14px; color: #15803d;">
                                <strong>Working Hours:</strong> {{ $working_hours }} hours
                            </div>
                        </div>
                    @endif
                    @if (isset($site_name) && !empty($site_name))
                        <div style="margin: 10px 0;">
                            <div style="font-size: 14px; color: #15803d;">
                                <strong>Site:</strong> {{ $site_name }}
                            </div>
                        </div>
                    @endif
                    @if (isset($assigned_by) && !empty($assigned_by))
                        <div style="margin: 10px 0;">
                            <div style="font-size: 14px; color: #15803d;">
                                <strong>Assigned by:</strong> {{ $assigned_by }}
                            </div>
                        </div>
                    @endif
                </div>
                @if (isset($shift_notes) && !empty($shift_notes))
                    <div class="note-container">
                        <strong>Shift Notes:</strong><br>
                        {{ $shift_notes }}
                    </div>
                @endif
                @if (isset($note) && !empty($note))
                    <div class="note-container">
                        <strong>Important Note:</strong><br>
                        {{ $note }}
                    </div>
                @endif
                <div class="info-box">
                    @if (isset($is_edit) && $is_edit)
                        If you have any questions about the changes made to your schedule, please contact your
                        supervisor or the HR department.
                    @else
                        If you have any questions or concerns about your schedule, please contact your supervisor or the
                        HR department.
                    @endif
                </div>
                <p class="thank-you-section">Thank you,<br>{{ $companyName }} Team</p>
            </div>
        </div>
        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>
            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    {{ $fullAddress }}<br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
