<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class MakeTrait extends Command
{
    protected $signature = 'make:trait {name : The name of the trait}';

    protected $description = 'Create a new trait';

    public function handle()
    {
        $name = $this->argument('name');
        $traitPath = app_path("Traits/{$name}.php");

        if (File::exists($traitPath)) {
            $this->error('Trait already exists!');
        } else {
            File::put($traitPath, $this->traitStub());
            $this->info("Trait {$name} created successfully!");
        }
    }

    protected function traitStub()
    {
        // Customize the trait stub as needed
        return "<?php\n\nnamespace App\Traits;\n\ntrait {$this->argument('name')}\n{\n    // Trait logic here\n}\n";
    }
}
