<?php

namespace App\Http\Controllers;

use App\Models\Coupon;
use Illuminate\Http\Request;

class CouponsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Coupon $coupon, Request $request)
    {
        // $activeCoupons = $coupon->active();      
        $coupons = $coupon->with('couponUsages');
        
        // Add search functionality if search parameter is provided
        if ($request->filled('search')) {
            $search = $request->input('search');
            $coupons->where(function($query) use ($search) {
                $query->where('name', 'like', '%' . $search . '%')  // Name
                      ->orWhere('code', 'like', '%' . $search . '%')  // Code
                      ->orWhere('type', 'like', '%' . $search . '%')  // Type
                      ->orWhere('discount', 'like', '%' . $search . '%')  // Discount
                      ->orWhere('limit', 'like', '%' . $search . '%')  // Limit
                      ->orWhere('limit_per_user', 'like', '%' . $search . '%')  // Limit Per User
                      // Search in expiry_date (format: Y-m-d or partial date)
                      ->orWhereRaw("DATE_FORMAT(expiry_date, '%Y-%m-%d') LIKE ?", ['%' . $search . '%'])
                      ->orWhereRaw("DATE_FORMAT(expiry_date, '%d-%m-%Y') LIKE ?", ['%' . $search . '%'])
                      ->orWhereRaw("DATE_FORMAT(expiry_date, '%m/%d/%Y') LIKE ?", ['%' . $search . '%']);
            });
        }
        
        return $this->withCount($coupons, "Coupons retrieved successfully.");
    }
    


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        return $this->storeCoupon($request);
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Coupons  $coupons
     * @return \Illuminate\Http\Response
     */
    public function show($coupon)
    {
       return $this->showCoupon($coupon);
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Coupons  $coupons
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        return $this->updateCoupon($request);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Coupons  $coupons
     * @return \Illuminate\Http\Response
     */
    public function destroy($coupon){
        return $this->destroyCoupon($coupon);
    }
    public function getCouponByCode($code)
    {
        $coupon = Coupon::without('couponUsages')->where('code', $code)->first();
        if (!$coupon) {
            return $this->message('Coupon not found', 404);
        }
        return $this->success($coupon, 'Coupon retrieved successfully');
    }
    
}
