<?php

namespace App\Http\Controllers;

use App\Models\SubModule;
use Illuminate\Http\Request;

class SubModuleController extends Controller
{
    public function index(SubModule $subModule , Request $request)
    {
        return $this->getLatestData($subModule, $request);
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        return $this->storeSubModule($request);
    }



    /**
     * Display the specified resource.
     */
    public function show($subModule)
    {
       return $this->showSubModule($subModule);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
       return $this->updateSubModule($request);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy($subModule)
    {
        return $this->destroySubModule($subModule);
    }
}
