<?php

namespace App\Http\Controllers\Traits;

use App\Models\Coupon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;


trait CouponTrait
{
    protected function showCoupon($coupon){
        $coupon = Coupon::find($coupon);
        if (!$coupon) {
            return $this->message( 'Coupon not found');
        }
        $coupon->load('plans');
        return $this->success($coupon, 'Coupon retrieved successfully');
    }

    protected function storeCoupon(Request $request)
    {
        // Validate the incoming request data
        $validator = $this->couponValidationRequest($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validatedData = $validator->validated();
        $code = $this->generateCode();
        $coupon = Coupon::create([
            'name' => $validatedData['name']  ?? null,
            'code' => $code  ?? null,
            'discount' => $validatedData['discount']  ?? null,
            'limit' => $validatedData['limit']  ?? null,
            'type' => $validatedData['type'] ?? null,
            'minimum_spend' => $validatedData['minimum_spend'] ?? null,
            'maximum_spend' => $validatedData['maximum_spend'] ?? null,
            'limit_per_user' => $validatedData['limit_per_user'],
            'expiry_date' => $validatedData['expiry_date'] ?? null,
            'included_plan' => $validatedData['included_plan']  ?? null,
            'excluded_plan' =>  null,
            'description' => $validatedData['description']  ?? null,
            'is_active' => $validatedData['is_active'] ?? 1,
            'is_deleted' => $validatedData['is_deleted'] ?? 0
        ]);
        if(!$coupon){
            return $this->error('something went wrong while creating Coupon');
        }
        return $this->success($coupon, 'Coupon created successfully');
    }

    protected function updateCoupon(Request $request)
    {
        $validator = $this->couponValidationRequest($request, true); 
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validatedData = $validator->validated();
        $coupon = Coupon::find($request->id);
        if (!$coupon) {
            return $this->message('Coupon not found');
        }
        $updated = $coupon->update([
            'name' => $validatedData['name'] ,
            'discount' => $validatedData['discount'],
            'limit' => $validatedData['limit']  ?? null,
            'type' => $validatedData['type']  ?? null,
            'minimum_spend' => $validatedData['minimum_spend'],
            'maximum_spend' => $validatedData['maximum_spend'],
            'limit_per_user' => $validatedData['limit_per_user'],
            'expiry_date' => $validatedData['expiry_date'],
            'included_plan' => $validatedData['included_plan'],
            'excluded_plan' => null ,
            'description' => $validatedData['description'],
            'is_active' => $validatedData['is_active']  ?? 1,
            'is_deleted' => $validatedData['is_deleted'] ?? 0

        ]); 
        if (!$updated) {
            return $this->error('Something went wrong while updating the coupon');
        }
        return $this->success($coupon, 'Coupon updated successfully');
    }

    protected function destroyCoupon($couponId)
    {
        $coupon = Coupon::find($couponId);
        if (!$coupon) {
            return $this->message('Coupon not found');
        }
        if($coupon->is_deleted == 1){
            return $this->message('Coupon Already deleted');
        }
        $coupon->update(['is_deleted' => 1]);
        return $this->message('Coupon  deleted successfully');
    }
    
}
