<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends BaseModel
{
    use HasFactory;
    protected $table = 'companies'; // This should fix the issue
    
    protected $fillable = [
        'name',
        'phone',
        'email',
        'address',
        'abn_number',
        'logo_img',
        'del',
        'status',
        'customer_id',
        'workspace_id',
        'created_by'
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function documents()
    {
        return $this->hasMany(CompanyDocument::class, 'c_id');
    }

    /**
     * Get the contact persons for the company.
     */
    public function contactPersons()
    {
        return $this->hasMany(CompanyContactPerson::class);
    }
}
