<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmployeeSubcontractor extends BaseModel
{
    use HasFactory;

    protected $table = 'employees_subcontractors';

    protected $fillable = [
        'emp_id',
        'subcontractor_id',
        'customer_id',
        'workspace_id',
        'del',
    ];

    /**
     * Get the employee that owns this subcontractor association.
     */
    public function employee()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'emp_id');
    }

    /**
     * Get the subcontractor (user) that owns this association.
     */
    public function subcontractor()
    {
        return $this->belongsTo(User::class, 'subcontractor_id');
    }
}
