<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentReportMeta extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_report_metas';

    protected $fillable = [
        'incident_report_id',
        'equipment_type',
        'registration_number',
        'damage',
        'cost',
        'shift_type',
        'shift_time',
        'incident_response'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }
}
