<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentReportedBy extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_reported_bys';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'reported_by',
        'company_name',
        'position',
        'contact_number'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function reportedByEmployee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'reported_by' , 'emp_id');
    }

    public function positionDetail()
    {
        return $this->belongsTo(Role::class, 'position','id');
    }
}
