<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentRiskCategoryDetail extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_risk_category_details';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'incident_risk_category_id',
        'details'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function riskCategory()
    {
        return $this->belongsTo(IncidentRiskCategory::class, 'incident_risk_category_id');
    }
}
