<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Salary extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'from',
        'to',
        'basic_salary',
        'working_hours',
        'customer_id',
        'workspace_id',
        'created_by',
    ];

    protected $casts = [
        'from' => 'date',
        'to' => 'date',
        'basic_salary' => 'decimal:2',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id', 'emp_id');
    }

    public function employeeCom()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'employee_id', 'id');
    }

    public function createdBy()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'created_by', 'emp_id');
    }

    // Scope for active salary periods
    public function scopeActive($query)
    {
        return $query->where('from', '<=', now())
                    ->where('to', '>=', now());
    }

    // Scope for salary in a specific period
    public function scopeForPeriod($query, $year, $month)
    {
        $period = sprintf('%04d-%02d', $year, $month);
        return $query->where('from', '<=', $period)
                    ->where('to', '>=', $period);
    }
} 