<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;

class SiteDiaryImage extends BaseModel
{
    use SoftDeletes;
    protected $table = 'site_diary_images';

    protected $fillable = [
        'site_diary_id',
        'image',
        'type',
        'customer_id',
        'workspace_id',
    ];
    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    // Relationships
    public function siteDiary()
    {
        return $this->belongsTo(SiteDiary::class, 'site_diary_id');
    }
}