<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class SubcontractorCompany extends BaseModel
{
    use HasFactory;

    protected $table = 'subcontractor_companies';

    protected $fillable = [
        'user_id',
        'customer_id',
        'workspace_id',
        'trade_id',
        'project_ids',
        'del',
    ];

    protected $casts = [
        'project_ids' => 'array',
    ];

    /**
     * Get the user (subcontractor) that owns this company association.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get the trade associated with this subcontractor company.
     */
    public function trade()
    {
        return $this->belongsTo(Trade::class, 'trade_id');
    }
}

