<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SwmsHazardRiskPivot extends BaseModel
{
    use HasFactory;
    protected $casts = [
        'hazard_risks_id' => 'integer',
    ];

    protected $fillable = [
        'swms_id', 
        'hazard_risks_id',
    ];

    // Relationship with the Swms model
    public function swms()
    {
        return $this->belongsTo(Swms::class, 'swms_id');
    }

    // Relationship with the HazardRisk model
    public function hazardRisk()
    {
        return $this->belongsTo(HazardRisk::class, 'hazard_risks_id');
    }
}
 