<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TenderAttachment extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'entity_type',
        'entity_id',
        'title',
        'file_name',
        'file_path',
        'uploaded_by',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    /**
     * Get the parent entity (tender or bid).
     */
    public function entity()
    {
        return $this->morphTo('entity', 'entity_type', 'entity_id');
    }

    /**
     * Get the user who uploaded this attachment.
     */
    public function uploadedBy()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }
}

