<?php

namespace App\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class NotDeletedScope implements Scope
{
    /**
     * Apply the scope to a given Eloquent query builder.
     * This will automatically exclude all records where del = 1
     */
   public function apply(Builder $builder, Model $model)
    {
        $builder->where(function ($query) {
            $query->where('del', '!=', 1)
                ->where(function ($q) {
                    $q->where('invited', 1)
                        ->orWhere(function ($subQ) {
                            $subQ->where('invited', 0)
                                ->where('approved', 1)
                                ->where('compeleted', 1)
                                ->where('status', 1);
                        });
                });
        });

    }
}