<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmpTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('emp_types', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('customer_id')->nullable(); // Makes the column nullable
            $table->integer('workspace_id')->nullable(); // Makes the column nullable
            $table->string('created_by');
            $table->string('del')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('emp_types');
    }
}
