<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    { 
        Schema::create('roster_templates', function (Blueprint $table) {
            $table->id();
            $table->time('start_time', $precision = 0);
            $table->time('end_time', $precision = 0);
            $table->string('color_code',10)->nullable();
            $table->integer('break_minutes')->nullable()->default(0);
            $table->text('shift_notes')->nullable();
            $table->string('repeat_shift')->nullable();
            $table->date('end_date')->nullable();
            $table->integer('is_saved')->default(0);
            $table->integer('created_by')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('project_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('roster_templates');
    }
}
