<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('risk_assessments', function (Blueprint $table) {
            $table->id();
            $table->string('customer_email')->index()->nullable();
            $table->string('transaction_type')->default('payment'); // payment, subscription, risk_update
            $table->decimal('amount', 10, 2)->default(0);
            $table->integer('risk_score')->default(50); // 0-100 scale
            $table->enum('risk_level', ['low', 'medium', 'high', 'very_high'])->default('medium');
            $table->boolean('payment_allowed')->default(true);
            $table->boolean('requires_3ds')->default(false);
            $table->decimal('max_amount_allowed', 10, 2)->default(1000);
            $table->json('risk_factors')->nullable(); // Store detailed risk factors
            $table->json('recommended_actions')->nullable(); // Store recommended actions
            $table->string('card_brand')->nullable(); // e.g., Visa, MasterCard
            $table->string('card_country', 2)->nullable(); // ISO country code
            $table->string('ip_country', 45)->nullable(); // ISO country code
            $table->string('ip_address', 45)->nullable(); // IPv4 or IPv6
            $table->string('card_fingerprint', 45)->nullable(); 
            $table->string('subscription_id' ,45)->nullable(); 
            $table->string('currency', 45)->nullable(); // IPv4 or IPv6
            $table->string('fraud_warning')->nullable(); // IPv4 or IPv6
            $table->string('payment_intent_id')->nullable();
            $table->enum('attempt_type', ['initial', 'retry'])->default('initial');
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['customer_email', 'created_at']);
            $table->index(['risk_level', 'created_at']);
            $table->index(['risk_score', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('risk_assessments');
    }
}; 