<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('whsqe_customer_selected_settings', function (Blueprint $table) {
            $table->id();
            $table->integer('whsq_report_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('parent_id')->nullable(); // WHSQE_TableOfContent ID
            $table->integer('child_id')->nullable(); // WHSQE_TableOfContentChild ID
            $table->integer('grandchild_id')->nullable(); // WHSQE_TableOfContentGrandChild ID
            $table->string('level')->nullable(); // Level of the setting
            $table->boolean('is_selected')->default(true);
            $table->integer('sort_order')->default(0);
            $table->integer('deleted_at')->default(0);
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['whsq_report_id', 'customer_id', 'workspace_id'], 'whsq_cust_report_idx');
            $table->index(['parent_id', 'child_id', 'grandchild_id'], 'whsq_cust_hierarchy_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whsqe_customer_selected_settings');
    }
}; 