<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('whsqe_content_dates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('content_meta_id');
            $table->date('date_value');
            $table->string('date_label')->nullable(); // Human readable label
            $table->string('date_type')->nullable(); // review_date, implementation_date, etc.
            $table->enum('level', ['parent', 'child', 'grandchild'])->default('parent'); // Which level this date belongs to
            $table->integer('level_id')->nullable(); // ID of the parent/child/grandchild
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index(['content_meta_id']);
            $table->index(['customer_id', 'workspace_id']);
            $table->index(['date_value']);
            $table->index(['level', 'level_id']);
            
            // Foreign key constraint
            $table->foreign('content_meta_id')->references('id')->on('whsqe_table_of_content_meta')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('whsqe_content_dates');
    }
}; 