<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentInjuryManagementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_injury_managements', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0);
            $table->string('date')->nullable();
            $table->string('time')->nullable();
            $table->string('representative_name')->nullable();
            $table->string('previous_injury_date')->nullable();
            $table->string('injured_names')->nullable();
            $table->integer('is_first_aid')->default(0);
            $table->integer('is_referred')->default(0);
            $table->integer('is_doctor')->default(0);
            $table->integer('is_clinic')->default(0);
            $table->integer('is_admit')->default(0);
            $table->integer('is_hospital_details')->default(0);
            $table->integer('return_to_work')->default(0);
            $table->integer('is_doctor_details')->nullable();
            $table->string('doctor_name')->nullable();
            $table->string('doctor_number')->nullable();
            $table->string('doctor_address')->nullable();
            $table->string('hospital_name')->nullable();
            $table->string('hospital_number')->nullable();
            $table->string('hospital_address')->nullable();
            $table->string('incident_response')->nullable();


            $table->integer('is_recurrence_injury')->default(0);
            $table->integer('previous_report_number')->nullable();
            $table->timestamps();
            $table->foreign('incident_report_id') ->references('id') ->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_injury_managements');
    }
}
