<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentReportNotifiableClassificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_report_notifiable_classifications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0); // Make it unsigned
            $table->unsignedBigInteger('notifiable_classification_id')->default(0); // Make it unsigned
            $table->timestamps();
        
            $table->foreign('incident_report_id', 'fk_incident_report')
                  ->references('id')
                  ->on('incident_reports')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
        });
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_report_notifiable_classifications');
    }
}
