<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewFieldsToEmpCompanyDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('emp_company_details', function (Blueprint $table) {
            $table->string('job_title')->nullable();
            $table->string('trade_qualified')->nullable();
            $table->string('trade_qualified_year')->nullable();
            $table->string('trade_licensed')->nullable();
            $table->string('trade_licensed_year')->nullable();
            $table->string('work_experience')->nullable();
            $table->string('temporary_student_visa')->nullable();
            $table->string('worker_type')->nullable();
            $table->string('year_commenced')->nullable();
            $table->string('classified_high_risk')->nullable();
            $table->string('citizenship_status')->nullable();
            $table->string('citizenship_file')->nullable();
            $table->string('allergies')->nullable();
            $table->string('previous_injuries')->nullable();
            $table->text('medical_condition')->nullable();
            $table->string('employer_name')->nullable();
            $table->string('legally_australia')->nullable();
            $table->string('link_key')->nullable();
            $table->string('signature')->nullable();
            $table->text('details_allergies')->nullable();
            $table->text('details_previous_injuries')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('emp_company_details', function (Blueprint $table) {
            //
        });
    }
}
