<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSwmsHazardRiskPivotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('swms_hazard_risk_pivots', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('swms_id')->nullable();
            $table->unsignedBigInteger('hazard_risks_id')->nullable();

            $table->timestamps();
            $table->foreign('swms_id')->references('id')->on('swms')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('hazard_risks_id')->references('id')->on('hazard_risks')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('swms_hazard_risk_pivots');
    }
}
