<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSwmsSignaturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('swms_signatures', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('swms_id')->nullable();
            $table->unsignedBigInteger('emp_id')->nullable();
            $table->string('signatures')->nullable();
            $table->string('job_desription')->nullable();
            $table->string('inductance_date')->nullable();

            $table->timestamps();
            $table->foreign('swms_id')->references('id')->on('swms')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('swms_signatures');
    }
}
