<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhsReportHazardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('whs_report_hazards', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('whs_report_id')->nullable();
            $table->string('level')->nullable();
            $table->string('hazard')->nullable();
            $table->string('action_required')->nullable();
            $table->string('level_of_action')->nullable();
            $table->unsignedInteger('role_id')->nullable();
            $table->date('date_completed')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whs_report_hazards');
    }
}
