<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMeetingDocumentNotesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meeting_document_notes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('meeting_id');
            $table->unsignedBigInteger('project_id')->nullable();
            $table->unsignedBigInteger('site_id')->nullable();
            $table->string('project_number')->nullable();
            $table->date('date')->nullable();
            $table->string('day_of_the_week')->nullable();
            $table->time('time_start')->nullable();
            $table->time('time_finish')->nullable();
            $table->string('weather_forecast_for_today')->nullable();
            $table->string('prestart_facilitated_by')->nullable();
            $table->text('comments_on_weather')->nullable();
            $table->text('additonal_items')->nullable();
            $table->text('office_review_comments')->nullable();
            $table->text('prestart_meeting_notes')->nullable();
            $table->string('type_of_setting')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meeting_document_notes');
    }
}
