<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('mobile_number')->nullable();
            $table->string('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->string('remember_token')->nullable();
            $table->integer('user_type')->nullable();
            $table->integer('active_status')->nullable();
            $table->integer('is_enable_login')->nullable();
            $table->integer('total_workspace')->nullable();
            $table->integer('demo_data')->nullable()->default('0');
            $table->integer('total_active_workspace')->nullable();
            $table->integer('total_user')->nullable();
            $table->integer('current_workspace_id')->nullable();
            $table->string('avatar')->nullable();
            $table->unsignedBigInteger('active_plan_id')->nullable()->index();
            $table->dateTime('plan_expire_date')->nullable();
            $table->string('company_name')->nullable();
            $table->string('abn')->nullable();
            $table->string('company_logo')->nullable();
            $table->string('company_number')->nullable();
            $table->unsignedBigInteger('current_company')->nullable();
            $table->unsignedBigInteger('current_company_workspace')->nullable();
            $table->string('created_by');
            $table->string('del')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
