<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBankTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_transfers', function (Blueprint $table) {
            $table->id();
            $table->string('order_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('request')->nullable();
            $table->integer('status')->nullable();
            $table->integer('type')->nullable();
            $table->string('payment_type')->nullable();
            $table->integer('bank_account_id')->nullable();
            $table->integer('price')->nullable();
            $table->string('price_currency')->nullable();
            $table->string('attachment')->nullable();
            $table->unsignedBigInteger('workspace')->nullable();
            $table->unsignedBigInteger('created_by')->nullable()->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_transfers');
    }
}
