<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPriceKeysToPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->string('price_key')->nullable()->after('number_of_workspace'); 
            $table->string('price_key_yearly')->nullable()->after('price_key'); 
        });
        Schema::table('users', function (Blueprint $table) {
            $table->string('cus_id')->nullable()->after('password'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn('price_key');
            $table->dropColumn('price_key_yearly');
        });
    }
}

