<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOvertimesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('overtimes', function (Blueprint $table) {
            $table->id();
            $table->integer('employee_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->datetime('check_in')->nullable(); // Stores both date and time
            $table->datetime('check_out')->nullable(); // Stores both date and time
            $table->date('date')->nullable(); // Specific column for just the date
            $table->float('working_hours')->nullable();
            $table->longText('description')->nullable();
            $table->string('status')->nullable(); // Status of the overtime
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('overtimes');
    }
}
