<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('defect_images', function (Blueprint $table) {
            $table->id();
            $table->integer('defect_id')->nullable();
            $table->integer('uploaded_by')->nullable(); // user or employee id
            $table->string('image')->nullable();
            $table->string('type')->nullable(); // customer|employee|completion
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->string('del')->default('0');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('defect_images');
    }
};

