<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('defect_histories', function (Blueprint $table) {
            $table->id();
            $table->integer('defect_id');
            $table->string('action'); // created, updated, reassigned, approved, rejected, completed, image_added
            $table->text('description')->nullable();
            $table->integer('changed_by')->nullable();
            $table->string('changed_by_type')->nullable(); // customer|employee
            $table->json('old_value')->nullable();
            $table->json('new_value')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('defect_histories');
    }
};

