<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        // Drop the unique index if it exists
        Schema::table('site_diaries', function (Blueprint $table) {
            $sm = Schema::getConnection()->getDoctrineSchemaManager();
            $indexes = $sm->listTableIndexes('site_diaries');
            
            if (array_key_exists('site_diary_unique', $indexes)) {
                $table->dropUnique('site_diary_unique');
            }
        });

        // Add unique constraint to site_diary
        Schema::table('site_diaries', function (Blueprint $table) {
            $table->unique(['site_id', 'diary_date', 'customer_id', 'workspace_id', 'del'], 'site_diary_unique');
        });

        // Drop the site_diary_logs table if it exists
        Schema::dropIfExists('site_diary_logs');

        // Create single logs table for all site diary related changes
        Schema::create('site_diary_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('site_diary_id')->constrained('site_diaries');
            $table->morphs('loggable'); // This will create loggable_type and loggable_id columns
            $table->foreignId('user_id')->nullable(); // For customer users
            $table->integer('emp_id')->nullable(); // For employee users
            $table->string('created_by_type')->nullable(); // For employee users
            $table->string('action_type')->nullable();
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();
            $table->text('notes')->nullable();
            $table->foreignId('customer_id');
            $table->foreignId('workspace_id');
            $table->timestamps();
        });

        // Replace boolean del with soft deletes
        Schema::table('site_diary_equipment', function (Blueprint $table) {
            if (Schema::hasColumn('site_diary_equipment', 'del')) {
                $table->dropColumn('del');
            }
            if (!Schema::hasColumn('site_diary_equipment', 'deleted_at')) {
                $table->softDeletes();
            }
        });

        Schema::table('site_diary_tasks', function (Blueprint $table) {
            if (Schema::hasColumn('site_diary_tasks', 'del')) {
                $table->dropColumn('del');
            }
            if (!Schema::hasColumn('site_diary_tasks', 'deleted_at')) {
                $table->softDeletes();
            }
        });

        Schema::table('site_diary_images', function (Blueprint $table) {
            if (Schema::hasColumn('site_diary_images', 'del')) {
                $table->dropColumn('del');
            }
            if (!Schema::hasColumn('site_diary_images', 'deleted_at')) {
                $table->softDeletes();
            }
        });
    }

    public function down()
    {
        Schema::dropIfExists('site_diary_logs');

        Schema::table('site_diaries', function (Blueprint $table) {
            $table->dropUnique('site_diary_unique');
        });

        Schema::table('site_diary_equipment', function (Blueprint $table) {
            if (!Schema::hasColumn('site_diary_equipment', 'del')) {
                $table->boolean('del')->default(false);
            }
            if (Schema::hasColumn('site_diary_equipment', 'deleted_at')) {
                $table->dropSoftDeletes();
            }
        });

        Schema::table('site_diary_tasks', function (Blueprint $table) {
            if (!Schema::hasColumn('site_diary_tasks', 'del')) {
                $table->boolean('del')->default(false);
            }
            if (Schema::hasColumn('site_diary_tasks', 'deleted_at')) {
                $table->dropSoftDeletes();
            }
        });

        Schema::table('site_diary_images', function (Blueprint $table) {
            if (!Schema::hasColumn('site_diary_images', 'del')) {
                $table->boolean('del')->default(false);
            }
            if (Schema::hasColumn('site_diary_images', 'deleted_at')) {
                $table->dropSoftDeletes();
            }
        });
    }
};
