<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSiteDocumentSignaturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_document_signatures', function (Blueprint $table) {
            $table->id();
            $table->integer('site_document_id');
            $table->integer('employee_id');
            $table->integer('site_id');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->text('signature')->nullable(); // Base64 encoded signature image
            $table->date('signed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_document_signatures');
    }
}
