<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTendersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tenders', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('reference')->nullable();
            $table->integer('project_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->date('closing_date')->nullable();
            $table->string('status')->nullable();
            $table->date('tender_issued_date')->nullable();
            $table->date('rfi_cut_off_date')->nullable();
            $table->text('scope_of_work')->nullable();
            $table->integer('reminder_days_before')->nullable();
            $table->boolean('allow_late_submissions')->nullable();
            $table->boolean('allow_bidder_document_uploads')->nullable();
            $table->timestamp('submitted_at')->nullable();
            $table->integer('bidder_id')->nullable();
            $table->decimal('total_base_bid', 15, 2)->nullable();
            $table->text('exclusions_clarifications')->nullable();
            $table->boolean('is_late_submission')->nullable();
            $table->boolean('is_published')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tenders');
    }
}
