<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeesSubcontractorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees_subcontractors', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('emp_id'); // Foreign key to emp_company_details.id
            $table->unsignedBigInteger('subcontractor_id'); // Foreign key to users.id (subcontractor user_type = 5)
            $table->unsignedBigInteger('customer_id')->nullable(); // Customer ID from subcontractor's current_company
            $table->unsignedBigInteger('workspace_id')->nullable(); // Workspace ID from subcontractor's current_company_workspace
            $table->string('del')->default('0');
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('emp_id')->references('id')->on('emp_company_details')->onDelete('cascade');
            $table->foreign('subcontractor_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees_subcontractors');
    }
}
