<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('users')->insert([
            'name' => 'Admin User',
            'email' => 'admin@example.com',
            'mobile_number' => '1234567890',
            'email_verified_at' => now(),
            'password' => Hash::make('password123'), // Use Hash for encrypting passwords
            'user_type' => 1, // Assume 1 represents admin type
            'active_status' => 1, // Active
            'is_enable_login' => 1, // Login enabled
            'total_workspace' => 10,
            'total_active_workspace' => 5,
            'total_user' => 50,
            'current_workspace_id' => 1,
            'avatar' => null,
            'active_plan_id' => null,
            'plan_expire_date' => null,
            'created_by' => 'System',
            'del' => '0',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}
