@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id ?? null);
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress =
        $companyDetails['companyAddressFull'] ??
        trim(
            ($companyAddress ?? '') .
                ', ' .
                ($companyCity ?? '') .
                ', ' .
                ($companyState ?? '') .
                ', ' .
                ($companyPostCode ?? '') .
                ', ' .
                ($companyCountry ?? ''),
        );
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif !important;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }

        #email-header {
            padding: 12px 18px;
            background: #fff !important;
        }

        #email-content {
            padding: 24px 22px;
        }

        .greeting-section {
            font-size: 13px;
            margin-bottom: 10px;
        }

        .email-content-area p {
            font-size: 13px;
            margin-bottom: 10px;
            line-height: 1.45;
        }

        .title {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 12px;
            color: #1f2937;
        }

        .details-container {
            background-color: #f0fdf4;
            padding: 16px 14px;
            border-radius: 6px;
            margin: 16px 0;
            border: 1px solid #22C55E;
        }

        .details-label {
            font-size: 11px;
            color: #16a34a;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 6px;
        }

        .details-item {
            margin-bottom: 8px;
        }

        .details-item-label {
            font-size: 13px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 4px;
        }

        .details-item-value {
            font-size: 14px;
            color: #15803d;
            background-color: #dcfce7;
            padding: 8px;
            border-radius: 4px;
        }

        .action-button {
            display: inline-block;
            margin-top: 10px;
            padding: 10px 18px;
            background-color: #22C55E;
            color: white !important;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 13px;
            text-align: center;
        }


        #email-footer {
            margin-top: 14px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 12px;
            text-align: center;
            font-size: 12px;
            color: #6b7280;
        }

        .small-tagline {
            font-size: 12px;
            color: #6b7280;
            margin-bottom: 2px;
        }

        .big-tagline {
            font-size: 13px;
            color: #374151;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .big-tagline a:hover {
            text-decoration: underline;
        }

        .company-details {
            text-align: center;
            padding: 14px 0;
            background-color: #ffffff;
        }

        .footer-logo {
            height: 30px;
            margin-bottom: 8px;
           
        }

        .company-title {
            font-size: 13px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 11px;
            line-height: 1.35;
        }
        /* App badge */
        .app-download { margin-top: 10px; }
        .store-card { display: inline-block; background: #0f172a; padding: 0px 10px; border-radius: 8px; box-shadow: 0 2px 6px rgba(0,0,0,0.15); }
        .store-badge { display: inline-block; line-height: 0; }
        .store-caption { font-size: 10px; color: #6b7280; margin-top: 6px; text-align: center; }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
                <h2 style="color: black; margin: 0; font-weight: 600;">{{ $companyName }}</h2>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">Hi {{ $assignee_name ?? 'there' }},</div>
            <div class="email-content-area">
                <p>You have a defect/task assigned to you. See the details below:</p>

                <div class="details-container">
                    <div class="details-label">Defect Details</div>

                    <div class="details-item">
                        <div class="details-item-label">Title</div>
                        <div class="details-item-value">{{ $defect_title }}</div>
                    </div> 
                    <div class="details-item">
                        <div class="details-item-label">Description</div>
                        <div class="details-item-value">{{ $defect_description ?? '' }}</div>
                    </div>

                    <div class="details-item">
                        <div class="details-item-label">Status</div>
                        <div class="details-item-value">{{ $defect_status_label }}</div>
                    </div>

                    <div class="details-item">
                        <div class="details-item-label">Priority</div>
                        <div class="details-item-value">{{ ucfirst($defect_priority) }}</div>
                    </div>

                    @if (!empty($defect_due_date))
                        <div class="details-item">
                            <div class="details-item-label">Due Date</div>
                            <div class="details-item-value">{{ $defect_due_date }}</div>
                        </div>
                    @endif

                    @if (!empty($reject_reason))
                        <div class="details-item">
                            <div class="details-item-label">Reject Reason</div>
                            <div class="details-item-value">{{ $reject_reason }}</div>
                        </div>
                    @endif
                </div>

             

                @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
                    <div class="app-download">
                        <div style="text-align: center;">
                            @if (env('APP_LINK_APPSTORE'))
                                <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                                    rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                                    <span class="store-badge">
                                        <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                            alt="Get it on Google Play"
                                            style="height: 42px; width: auto; border: 0; display: block;">
                                    </span>
                                </a>
                            @endif
                            @if (env('APP_LINK_APPSTORE_Apple'))
                                <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                                    rel="noopener"
                                    style="background: #000000; padding: 8px 12px; border-radius: 8px; display: inline-block; vertical-align: middle; text-decoration: none; height: 48px; box-sizing: border-box; line-height: 0;">
                                    <table role="presentation" cellpadding="0" cellspacing="0" border="0"
                                        style="margin: 0; padding: 0; height: 100%;">
                                        <tr style="height: 100%;">
                                            <td style="padding: 0 6px 0 0; vertical-align: middle;">
                                                <img src="https://img.icons8.com/?size=100&id=30840&format=png&color=FFFFFF"
                                                    alt="Apple"
                                                    style="width: 18px; height: 18px; display: block; border: 0;">
                                            </td>
                                            <td style="padding: 0; vertical-align: middle;">
                                                <div
                                                    style="color: #FFFFFF; font-size: 7px; letter-spacing: 0.5px; line-height: 9px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 400; white-space: nowrap;">
                                                    Download on the</div>
                                                <div
                                                    style="color: #FFFFFF; font-size: 12px; line-height: 14px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif; font-weight: 600; margin-top: 1px; white-space: nowrap;">
                                                    App Store</div>
                                            </td>
                                        </tr>
                                    </table>
                                </a>
                            @endif
                        </div>
                        <div class="store-caption">Tap to download our mobile app</div>
                    </div>
                @endif

               
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>

            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    {{ $fullAddress }}<br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
