@php
  use Illuminate\Support\Facades\DB;
  use App\Models\User;
  
    // Default values
  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
  
  // Determine if this is for admin or user
  $isAdminEmail = isset($is_admin_notification) && $is_admin_notification;
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject ?? ($isAdminEmail ? 'New Demo Request Submission' : 'Thank you for your demo request') }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      font-family: 'Inter', sans-serif !important;
    }
    
    #email-body {
      min-width: 600px;
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
    }
    
    #email-header {
      padding: 18px 25px;
      background-color: #fff;
    }
    
    #email-content {
      padding: 42px 34px;
    }
    
    .greeting-section {
      font-size: 14px;
      margin-bottom: 18px;
    }
    
    .email-content-area p {
      font-size: 14px;
      margin-bottom: 15px;
      line-height: 1.5;
    }
    
    .demo-title {
      font-size: 20px;
      font-weight: 700;
      margin-bottom: 18px;
      color: #1f2937;
    }
    
    .demo-details {
      background-color: #f9f9f9;
      padding: 20px;
      border-radius: 8px;
      margin-bottom: 20px;
      border-left: 4px solid #3B82F6;
    }
    
    .demo-details p {
      margin-bottom: 8px;
      font-size: 14px;
    }
    
    .demo-details strong {
      font-weight: 600;
      color: #374151;
    }
    
    .info-box {
      background-color: #f8fafc;
      padding: 20px;
      border-radius: 8px;
      margin-bottom: 20px;
      border: 1px solid #e2e8f0;
    }
    
    .info-box h3 {
      margin-bottom: 12px;
      color: #374151;
      font-size: 16px;
      font-weight: 600;
    }
    
    .info-content {
      background-color: #ffffff;
      padding: 15px;
      border-radius: 6px;
      border-left: 3px solid #3B82F6;
      color: #4b5563;
      line-height: 1.6;
    }
    
    .thank-you-section {
      margin-top: 25px;
      margin-bottom: 0;
      font-weight: 500;
    }
    
    .info-highlight {
      background-color: #dbeafe;
      padding: 15px;
      border-radius: 6px;
      margin-bottom: 20px;
      border-left: 3px solid #3B82F6;
    }
    
    .info-highlight p {
      margin-bottom: 8px;
      color: #1e40af;
      font-size: 13px;
    }
    
    #email-footer {
      margin-top: 20px;
    }
    
    #tagline-section {
      background-color: #EDEDED;
      padding: 16px;
      text-align: center;
      font-size: 13px;
      color: #6b7280;
    }
    
    .small-tagline {
      font-size: 13px;
      color: #6b7280;
      margin-bottom: 4px;
    }
    
    .big-tagline {
      font-size: 14px;
      color: #374151;
    }
    
    .big-tagline a {
      color: #787f83;
      font-weight: 600;
      text-decoration: none;
    }
    
    .big-tagline a:hover {
      text-decoration: underline;
    }
    
    .company-details {
      text-align: center;
      padding: 20px 0;
      background-color: #ffffff;
    }
    
    .footer-logo {
      height: 35px;
      margin-bottom: 10px;
     
    }
    
    .company-title {
      font-size: 14px;
      font-weight: 600;
      color: #374151;
      margin-bottom: 5px;
    }
    
    .company-address-contact {
      color: #6b7280;
      font-size: 12px;
      line-height: 1.4;
    }
    
    .status-badge {
      display: inline-block;
      background-color: #3B82F6;
      color: #ffffff;
      padding: 4px 8px;
      border-radius: 12px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }
    
    .admin-badge {
      background-color: #dc2626;
      color: #ffffff;
    }
    
    .user-badge {
      background-color: #059669;
      color: #ffffff;
    }
    
    .submitted-time {
      font-size: 12px;
      color: #6b7280;
      margin-top: 10px;
    }
    
    .urgency-note {
      background-color: #fef3c7;
      padding: 12px;
      border-radius: 6px;
      border-left: 3px solid #f59e0b;
      margin-bottom: 20px;
    }
    
    .urgency-note p {
      color: #92400e;
      font-size: 13px;
      font-weight: 500;
    }
    
    .consent-badge {
      display: inline-block;
      padding: 4px 10px;
      border-radius: 12px;
      font-size: 11px;
      font-weight: 600;
      margin-left: 8px;
    }
    
    .consent-yes {
      background-color: #d1fae5;
      color: #065f46;
    }
    
    .consent-no {
      background-color: #fee2e2;
      color: #991b1b;
    }
  </style>
</head>
<body>
  <div id="email-body">
    <div id="email-header">
      @if(!empty($logoPath) && file_exists(public_path($logoPath)))
        <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
      @else
        <h2 style="color: #374151; margin: 0; font-weight: 600;">{{ $companyName }}</h2>
      @endif
    </div>
    
    <div id="email-content">
      @if($isAdminEmail)
        {{-- Admin Notification Email --}}
        <div class="greeting-section">Hi, <b>Admin</b></div>
        
        <div class="email-content-area">
          <p class="demo-title">🔔 New Demo Request <span class="status-badge admin-badge">Received</span></p>
          
          <p>A new demo request has been submitted through your website. Please review the details below and schedule a personalized demo for the customer.</p>
          
          <div class="demo-details">
            <p><strong>👤 Name:</strong> {{ $first_name }} {{ $last_name }}</p>
            <p><strong>📧 Work Email:</strong> {{ $work_email }}</p>
            <p><strong>📱 Phone:</strong> {{ $phone }}</p>
            <p><strong>🏢 Company Name:</strong> {{ $company_name }}</p>
            <p><strong>🏭 Company Type:</strong> {{ $company_type }}</p>
            <p><strong>👥 Company Size:</strong> {{ $company_size ?? 'N/A' }} employees</p>
            <p><strong>📧 Email Consent:</strong> 
              @if(isset($email_consent) && $email_consent)
                <span class="consent-badge consent-yes">✓ Yes</span>
              @else
                <span class="consent-badge consent-no">✗ No</span>
              @endif
            </p>
            <p class="submitted-time"><strong>🕒 Submitted:</strong> {{ $submitted_at ?? now()->format('M d, Y \a\t g:i A') }}</p>
          </div>
          
          <div class="info-box">
            <h3>📋 Demo Request Summary</h3>
            <div class="info-content">
              <p><strong>Customer:</strong> {{ $first_name }} {{ $last_name }} from {{ $company_name }}</p>
              <p><strong>Contact:</strong> {{ $work_email }} | {{ $phone }}</p>
              <p><strong>Company Details:</strong> {{ $company_type }} company with {{ $company_size ?? 'N/A' }} employees</p>
            </div>
          </div>
          
          <div class="urgency-note">
            <p><strong>⚡ Action Required:</strong> Please contact this customer within 24-48 hours to schedule their personalized demo. This is a high-priority lead that requires prompt follow-up.</p>
          </div>
          
          <div class="info-highlight">
            <p><strong>📧 Reply To:</strong> {{ $work_email }}</p>
            <p><strong>📞 Contact Number:</strong> {{ $phone }}</p>
            <p><strong>💡 Tip:</strong> Reach out to schedule a demo at their convenience. They have expressed interest in learning more about our platform.</p>
          </div>
          
          <p>This demo request has been automatically logged in your system for tracking and follow-up purposes.</p>
          
          <p class="thank-you-section">Best regards,<br>{{ $companyName }} Demo Request System</p>
        </div>
      @else
        {{-- User Confirmation Email --}}
        <div class="greeting-section">Hi, <b>{{ $first_name }}</b> 👋</div>
        
        <div class="email-content-area">
          <p class="demo-title">✅ Your Demo Request Has Been <span class="status-badge user-badge">Received</span></p>
          
          <p>Thank you for your interest in {{ $companyName }}! We have successfully received your demo request and our team will contact you shortly to schedule a personalized demo.</p>
          
          <div class="demo-details">
            <p><strong>👤 Name:</strong> {{ $first_name }} {{ $last_name }}</p>
            <p><strong>📧 Work Email:</strong> {{ $work_email }}</p>
            <p><strong>📱 Phone:</strong> {{ $phone }}</p>
            <p><strong>🏢 Company Name:</strong> {{ $company_name }}</p>
            <p><strong>🏭 Company Type:</strong> {{ $company_type }}</p>
            <p><strong>👥 Company Size:</strong> {{ $company_size ?? 'N/A' }} employees</p>
            <p class="submitted-time"><strong>🕒 Submitted:</strong> {{ $submitted_at ?? now()->format('M d, Y \a\t g:i A') }}</p>
          </div>
          
          <div class="info-box">
            <h3>📅 What Happens Next?</h3>
            <div class="info-content">
              <p><strong>1. Review:</strong> Our team will review your demo request</p>
              <p><strong>2. Contact:</strong> We'll reach out to you within 24-48 hours</p>
              <p><strong>3. Schedule:</strong> We'll work with you to find the perfect time for your personalized demo</p>
              <p><strong>4. Demo:</strong> Experience our platform tailored to your needs</p>
            </div>
          </div>
          
          <div class="info-highlight">
            <p><strong>⏰ Expected Response Time:</strong> We typically respond within 24-48 hours during business days.</p>
            <p><strong>📧 Response Email:</strong> Our reply will be sent to {{ $work_email }}</p>
            <p><strong>📞 Need Immediate Help?:</strong> For urgent matters, please call us at {{ $companyPhone }}</p>
          </div>
          
          <p>Our dedicated sales team has been notified about your demo request and will get back to you as soon as possible. We're excited to show you how {{ $companyName }} can help your business grow!</p>
          
          <p>If you have any questions or need to modify your demo request, please feel free to contact us directly.</p>
          
          <p class="thank-you-section">Thank you for choosing {{ $companyName }},<br>Sales Team</p>
        </div>
      @endif
    </div>
    
    <div id="email-footer">
      <div id="tagline-section">
        @if($isAdminEmail)
          <p class="small-tagline">This is an admin notification email from your demo request system.</p>
          <p class="big-tagline">For system support, contact 
            <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
          </p>
        @else
          <p class="small-tagline">This is an auto-generated confirmation email. Please do not reply directly.</p>
          <p class="big-tagline">For questions or support, contact 
            <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
          </p>
        @endif
      </div>
      
      <div class="company-details">
        @if(!empty($logoPath) && file_exists(public_path($logoPath)))
          <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
        @endif
        <div class="company-title">{{ $companyName }}</div>
        <div class="company-address-contact">
          @if(!empty($fullAddress))
            {{ $fullAddress }}<br>
          @endif
           {{ $companyPhone }} 
        </div>
      </div>
    </div>
  </div>
</body>
</html>

